import json
import glob

def convert_mcq(input_file, output_file):
    choice_letter = ["A", "B", "C", "D"]
    with open(input_file, 'r') as infile, open(output_file, 'w') as outfile:
        for line in infile:
            data = json.loads(line)
            new_data = {
                "text": "\n".join([
f"Question: {data['question']}",
*[f"{letter}. {choice}" for letter, choice in zip(choice_letter, data["choices"])],
f"Answer: {choice_letter[data['answer']]}. {data['choices'][data['answer']]}",
]),
                "question": data["question"],
                "choices": data["choices"],
                "answer": data["answer"],
            }
            json.dump(new_data, outfile)
            outfile.write('\n')

for file in glob.glob('split_*.jsonl'):
    output_file = f"mcq_{file}"
    convert_mcq(file, output_file)

print("Conversion complete.")
